#include <iostream>
#include "icsneo/icsneocpp.h"
#include <string_view>
#include <vector>
#include <memory>

std::shared_ptr<icsneo::Device> find_device(const char* serial)
{
    for (auto&& dev : icsneo::FindAllDevices()) {
        if (dev->getSerial() == std::string_view(serial)) {
            return dev;
        }
    }
    return nullptr;
}


int main(int argc, const char** argv)
{
    if (argc != 2) {
        std::cout << "usage: " << argv[0] << " <serial>" << std::endl;
        return -1;
    }
    auto device = find_device(argv[1]);
    if (!device) {
        std::cerr << "error: unable to find device" << std::endl;
        return -1;
    }
    device->open();
    std::cout << *device << std::endl;
    if (!device->requestTC10Sleep(icsneo::Network::NetID::OP_Ethernet1)) {
        std::cerr << "unable to send TC10 Sleep Request" << std::endl;
        return -1;
    }
    return 0;
}