#include <iostream>
#include "icsneo/icsneocpp.h"
#include <string_view>
#include <vector>
#include <memory>

std::shared_ptr<icsneo::Device> find_device(const char* serial)
{
    for (auto&& dev : icsneo::FindAllDevices()) {
        if (dev->getSerial() == std::string_view(serial)) {
            return dev;
        }
    }
    return nullptr;
}


int main(int argc, const char** argv)
{
    if (argc != 2) {
        std::cout << "usage: " << argv[0] << " <serial>" << std::endl;
        return -1;
    }
    auto device = find_device(argv[1]);
    if (!device) {
        std::cerr << "error: unable to find device" << std::endl;
        return -1;
    }
    device->open();
    std::cout << *device << std::endl;
    const auto status = device->getTC10Status(icsneo::Network::NetID::OP_Ethernet1);
    if (!status) {
        std::cerr << "unable to get TC10 status" << std::endl;
        return -1;
    }
    std::cout << "wake status: " << (int)status->wakeStatus << std::endl;
    std::cout << "sleep status: " << (int)status->sleepStatus << std::endl;
    return 0;
}