# Installing Dependencies
The following dependencies are required:  
- python_ics

# Packages
`pip install pyyaml`

# Running MACSec utility
Provide arguments for:
- device serial number
  - supported devices:
    - RADComet2 (RCxxxx)
    - RADMoon2_zl (RNxxxx)
    - RADMoon3 (R3xxxx)
    - RADGigastar w/ SFP-MV2221M (GSxxxx)
- port
  - netid
    - `NETID_OP_ETHERNET1` for RADMoon3 and RADMoon2 and RADComet2
    - `NETID_ETHERNET` for RADGigastar SFP1 port
    - `NETID_ETHERNET2` for RADGigastar SFP2 port
  - config_netid
    - `NETID_MDIO_01` for RADMoon3 and RADMoon2
    - `NETID_MDIO_02` for RADComet2
    - `NETID_I2C2` for RADGigastar SFP1 port
    - `NETID_I2C3` for RADGigastar SFP2 port
- yaml
  - MACsec configuration yaml file name
  - *Assumes .yml is located in "/yaml/" directory

See `-h` for help text.

# Example (RADComet2):
```
python ics_load_macsec.py RCxxxx --port "{'netid':NETID_OP_ETHERNET1,'config_netid':NETID_MDIO_02}" --yaml "test_sfp_macsec_Rule_wildcard_SecY_128_strip_strict_sci_SA_sak0.yml"
```
# Example (RADMoon2):
```
python ics_load_macsec.py RNxxxx --port "{'netid':NETID_OP_ETHERNET1,'config_netid':NETID_MDIO_01}" --yaml "test_sfp_macsec_Rule_wildcard_SecY_128_strip_strict_sci_SA_sak0.yml"
```
# Example (RADMoon3):
```
python ics_load_macsec.py R3xxxx --port "{'netid':NETID_OP_ETHERNET1,'config_netid':NETID_MDIO_01}" --yaml "test_sfp_macsec_Rule_wildcard_SecY_128_strip_strict_sci_SA_sak0.yml"
```
# Example (RADGigastar Port1 with SFP-MV2221M):
```
python ics_load_macsec.py GSxxxx --port "{'netid':NETID_ETHERNET,'config_netid':NETID_I2C2}" --yaml "test_sfp_macsec_Rule_wildcard_SecY_128_strip_strict_sci_SA_sak0.yml"
```
# Example (RADGigastar Port2 with SFP-MV2221M):
```
python ics_load_macsec.py GSxxxx --port "{'netid':NETID_ETHERNET2,'config_netid':NETID_I2C3}" --yaml "test_sfp_macsec_Rule_wildcard_SecY_128_strip_strict_sci_SA_sak0.yml"
```

# Reset/Clear the MACsec configuration
Add `--reset` argument. Any MACsec configuration will be cleared and MACsec will be disabled on the selected device/port. 
*Make sure to remove `--reset` argument before configuring MACsec on the module again.

# New MACsec configuration
"/yaml/" folder contains 8 existing MACsec yaml configurations to showcase specific use cases of MACsec. 
To add a new/custom MACsec configuration, add a new .yml file to the "/yaml/" folder in the same format as any of the existing files and edit the MACsec parameters.

## Version History
- (04/17/2024)
  - Drive created with the following files:
    - util
      - util_eth.py
      - util_exit.py
      - util_i2c.py
      - util_macsec.py
      - util_sfp.py
      - util.py
    - yaml
      - test_macsec_Rule_wildcard_SecY_128_strip_strict_sci_SA_sak0.yml
      - test_macsec_Rule_wildcard_SecY_128_strip_strict_sci_SA_sak1.yml
      - test_macsec_Rule_wildcard_SecY_256_strip_strict_sci_SA_sak0.yml
      - test_macsec_Rule_wildcard_SecY_256_strip_noEncrypt_onlyCheck_sci_SA_sak0.yml
      - test_macsec_Rule_wildcard_SecY_256_strip_noEncrypt_onlyCheck_sci_SA_sak1.yml
      - test_macsec_Rule_txmacsa_rxmacda_SecY_128_strip_strict_sci_SA_sak0.yml
      - test_macsec_Rule_macsa_SecY_128_strip_strict_sci_SA_sak0.yml
      - test_macsec_Rule_macda_SecY_128_strip_strict_sci_SA_sak0.yml
      - test_macsec_PlugFest_Default_wildcard_protectedOnly_NoSci.yml
    - ics_load_macsec.py
    - README.md
